using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.DAL
{
	public partial class STD_FORM_QUESTIONDB : VIRP.DBUtils
	{
		#region Fields
		#endregion

		#region Constructors

		public STD_FORM_QUESTIONDB()
		{
		}

		#endregion

		#region Properties
		#endregion

		#region Methods

		public STD_FORM_QUESTION GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_FORM_QUESTION_ID)
		{
			STD_FORM_QUESTION objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_STD_FORM_QUESTION_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, STD_FORM_QUESTION_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<STD_FORM_QUESTION> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<STD_FORM_QUESTION> objReturn = null;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_STD_FORM_QUESTION_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_FORM_QUESTION objSave)
		{
			Int32? objReturn = objSave.STD_FORM_QUESTION_ID;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_STD_FORM_QUESTION_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.BRP_FORM_QUESTION_ID, objSave.BRP_PARENT_QUESTION_ID, DateTime.Now, objSave.CREATEDBY, objSave.FORM_QUESTION_UNIQUE_ID, objSave.MAX, objSave.MAX_CHOICES, objSave.MAX_LENGTH, objSave.MIN, objSave.MIN_LENGTH, objSave.PARENT_ID, objSave.POST_REQ_TRIGGER_ONCE, objSave.PRE_REQ_OPERATOR, objSave.SHORT_TEXT, objSave.SOURCE_ID, objSave.STD_FORM_ID, ref objReturn, objSave.STD_FORM_SECTION_ID, objSave.STD_FORM_SUB_SECTION_ID, objSave.TEXT, objSave.TYPE, DateTime.Now, objSave.UPDATEDBY);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_FORM_QUESTION_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (AHOBPRDBDataContext dbContext = GetAHOBPRDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_STD_FORM_QUESTION_delete(CURRENT_USER, CURRENT_REGISTRY_ID, STD_FORM_QUESTION_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
